<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2025-05-13 06:09
 */
interface OnlineproductcatDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Onlineproductcat 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param onlineproductcat primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Onlineproductcat onlineproductcat
 	 */
	public function insert($onlineproductcat);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Onlineproductcat onlineproductcat
 	 */
	public function update($onlineproductcat);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByParentid($value);

	public function queryByTitle($value);

	public function queryByTitleEn($value);

	public function queryByDescription($value);

	public function queryByDescriptionEn($value);

	public function queryByImage($value);

	public function queryBySysDate($value);

	public function queryByUserid($value);

	public function queryByIsdel($value);


	public function deleteByParentid($value);

	public function deleteByTitle($value);

	public function deleteByTitleEn($value);

	public function deleteByDescription($value);

	public function deleteByDescriptionEn($value);

	public function deleteByImage($value);

	public function deleteBySysDate($value);

	public function deleteByUserid($value);

	public function deleteByIsdel($value);


}
?>